
/*  */
/*
		RS232
		Sample program for communicating with interface HO79
		Interrupt 14H used
		The sample program expects a RS232 input buffer to
		  read all data from the interface
		RS232-R1.EXE is a memory resident program which provides 
		  this buffer. Call this program once after the PC boots.
		  Thereafter access to the buffered data is enabled via 
		  the BIOS call.
		  When using COM1 call: RS232-R1
		  when using COM2 call: RS232-R2

*/

/*  */

#include <bios.h>
#include <conio.h>

/*  */
/*		Key code used in bioskey() high byte                        */

#define ESC  01

#define F1  59
#define F2  60
#define F3  61
#define F4  62
#define F5  63
#define F6  64
#define F7  65
#define F8  66
#define F9  67
#define F10 68


/*  */
/* 		Parameters for serial interface int 14h                     */

#define COM1 0                         /* serial port 1 */
#define COM2 1                         /* serial port 2 */

/* Commands for BIOS call Int 14h */
#define INIT	0
#define SEND	1
#define RECEIVE	2
#define STATUS	3

/* Parameters for the serial interface */
#define BD9600	0xE0				/* Baud rate  */
#define BD4800	0xC0
#define BD2400	0xA0
#define BD1200	0x80

#define EVEN	0x18				/* Parity */
#define ODD	0x08
#define NONE	0x00

#define STOP_1	0x00                /* Stop bits */
#define STOP_2	0x04

#define BITS_8  0x03                /* Data bits */
#define BITS_7  0x02


/*  */
/*	Commands for interface HO79                                         */

char	id[]="ID?\x0D";
char	dig[]="DIG\x0D";
char	get[]="GET\x0D";
char	frm0[]="FRM 0\x0D";
char	dummy[] = "\x00";
/*  */
/*	Flag to terminate the program                                       */

char	ende = 0;

/*  */

struct win {
char	l,t,r,b;                 /* l:left; t:top; r:right; b:bottom   */
char	x,y;                     /* x:Cursor-x-Position, y:Cursor-y-P. */
char	c,bg;                    /* c:Color; bg:Background             */
};

/* Data for Window organisation */

struct win header_win = {
	1,1,80,1,	1,1,	YELLOW, CYAN
};

struct win fkt_win = {
	1,25,80,25,	1,1,	YELLOW, CYAN
};

struct win recv_win = {
	1,3,80,20,	1,1,	WHITE, BLUE
};

struct win send_win = {
	1,22,80,23,	1,1,	LIGHTRED, BLUE
};

/*  */
/* Prototypes                                                               */

int main (void);
void set_window (struct win *);


/*  */
/*
	Short program description :
	Display title and function key settings
	Main loop with three items
	1. Data transfer, activated by keyboard inputs
	   1.1 ASCII key:    transmit character
	   1.2 Function key: transmit command
	2. Receive data and display data in readable format
	3. Terminate program by pushing F10 or ESC
*/

int main ()
{
char				port;				/* interface used */
int					key;				/* bioskey code */
int					com_status;			/* line status after BIOS call */
char				*cmd;				/* command for interface */
struct text_info 	in_ti, out_ti;


/* Display settings */
	textcolor(WHITE);
	textbackground(BLUE);
	clrscr();

/* Initialisation of serial interface */
/* Bios int 14h used                      */
	port=COM1;
	bioscom(INIT, BD9600 | NONE | STOP_1 | BITS_8, port);


	/* Identification line */
	set_window (&header_win);
	clreol();
	cprintf (" C - DEMO            Interface HO79          HAMEG GmbH Software Support 1991 ");

	set_window (&fkt_win);
	clreol();
	cprintf ("  F1-ID?   F2-DIG   F3-GET                                            F10-EXIT");


	/* Initialize RECEIVE window */
	set_window (&recv_win);

	/* set binary format */
	cmd = frm0;
	while (*cmd!=0) {
		bioscom(SEND, *cmd, port);
		cmd++;
	};
	do {
		/* Check if data in input buffer */
		com_status = bioscom(RECEIVE, 0, port);
		if ((com_status & 0x8000)==0)  /* TIMEOUT or data received */
			cprintf ("%c", (char) com_status);

		/* Check keyboard buffer */
		if (bioskey(1) != 0) {
			key = bioskey(0);
			switch (key>>8) {
				case F1 : 	cmd=id;  break;
				case F2 : 	cmd=dig; break;
				case F3 : 	cmd=get; break;
				case F10 :
				case ESC :	ende = 1; break;
				default :   cmd = dummy;
							*cmd = (key & 0xFF);


					break;
			}
		}
		/* If transmit buffer not empty: display data and transmit */
		if (*cmd!=0) {
			/* Save actual cursor positions and open Tx window */
			recv_win.x = wherex();
			recv_win.y = wherey();
			set_window (&send_win);
			while (*cmd!=0) {
				bioscom(SEND, *cmd, port);
				cprintf ("%c", *cmd);
				if (*cmd == 13) {
					gotoxy (1,1);
					clreol ();
				}
				cmd++;
			};
			send_win.x = wherex();
			send_win.y = wherey();
			set_window (&recv_win);
		}

	} while (ende==0);
	return (0);
}

/*  */
/*
   set_window

   Windos settings:
   window corners, cursor positions, and window colors
*/

void set_window (w)
struct win		*w;
{
	window((*w).l,(*w).t,(*w).r,(*w).b);
	textcolor((*w).c);
	textbackground((*w).bg);
	gotoxy ((*w).x, (*w).y);

	return;
}

/*  */

